<?php

namespace UtillzCore\Inc\Src\Admin\Http\Endpoints;

use \UtillzCore\Inc\Src\Request\Request;

if ( ! defined('ABSPATH') ) {
	exit;
}

class Endpoint_Dev_Export_Options extends Endpoint {

	public $action = 'utillz-dev-export-options';

	protected $ignore = [
		'ulz_mapbox_access_token',
		'ulz_enable_facebook_auth',
		'ulz_facebook_app_id',
		'ulz_facebook_app_secret',
		'ulz_enable_google_auth',
		'ulz_google_client_id',
		'ulz_google_client_secret',
	];

    public function action() {

		$options = [];
		foreach( wp_load_alloptions() as $key => $value ) {
			if( Ucore()->is_prefixed( $key ) ) {

				// skip some sensitive information
				if( in_array( $key, $this->ignore ) ) {
					continue;
				}

				$options[ $key ] = $value;
				
			}
		}

		wp_send_json([
			'success' => true,
			'output' => wp_json_encode( $options )
		]);

	}

}
